/*!
Code in this file was copied from the Extra theme, copyright Elegant Themes.
Used in this project under the GNU General Public License version 3 (GPLv3).
See ../license.txt for the GPLv3 license text.
*/

function agsdcm_extra($module) {
	var $ = $module
			? function(selector) {
				return $module.find(selector);
			}
			: jQuery;
	
	var //$comment_form = $('#commentform'),
		//$rating_stars = $('#rating-stars'),
		$tabbed_post_module = $('.tabbed-post-module'),
		$post_module = $('.post-module'),
		$et_slider = $('.et-slider'),
		$featured_posts_slider_module = $('.featured-posts-slider-module'),
		$posts_carousel_module = $('.posts-carousel-module'),
		//$filterable_portfolio = $('.et_filterable_portfolio'),
		//$timeline = $('#timeline'),
		//$contact_form = $('.extra-contact-form'),
		//$post_format_map = $('.post-format-map'),
		$paginated = $('.paginated'),
		$internal_links = $('a[href^="#"]:not([href="#"])');
		//$back_to_top = $('#back_to_top'),
		//$social_share_icons = $('.ed-social-share-icons'),
		//$woocommerce_details_accordion = $('.extra-woocommerce-details-accordion'),
		//$search_icon = $('#et-search-icon'),
		//$et_trending_container = $('#et-trending-container'),
		//$widget_et_recent_videos = $('.widget_et_recent_videos'),
		//$et_top_cart_total = $('.et-top-cart-total');
		
	var $ = jQuery;
	

	function paginated_transition_page($this_paginated, to_page) {
		var $this = $this_paginated,
			$paginated_pages = $this.find('.paginated_page'),
			window_width = $(window).width();

		$this.data('current_page', to_page);

		paginated_update_pagination($this);
		
		$paginated_pages.removeClass('active').hide();
		$paginated_pages.filter('.paginated_page_' + to_page).addClass('active').fadeIn('fast', function () {

			if ($('body').hasClass('et_fixed_nav') && 980 < window_width) {
				$menu_offset = ( $('#top-header').outerHeight() || 0 ) + ( $('#main-header').outerHeight() || 0 ) - 1;
			} else {
				$menu_offset = -1;
			}

			var scroll_to_top_offset = ($this_paginated.offset().top - $menu_offset - et_calclate_admin_bar_height() - 20);

			if ($('html').scrollTop()) {
				$('html').animate({
					scrollTop: scroll_to_top_offset
				}, {
					duration: 500,
				});

				return;
			}

			$('body').animate({
				scrollTop: scroll_to_top_offset
			}, {
				duration: 500,
			});
		});
	}

	function paginated_update_pagination($this_paginated) {
		var current_page = $this_paginated.data('current_page'),
			$pagination = $this_paginated.find('.pagination'),
			total_pages = $pagination.find('li').not('.arrow, .ellipsis').length,
			show_front = false,
			show_back = false;

		$pagination.find('li').removeClass('active');
		$pagination.find('li').not('.arrow, .ellipsis').each(function (i) {

			var $this = $(this);
			i = i + 1;

			if (i === current_page) {
				$this.addClass('active');
			}

			if (total_pages > 5) {
				if (i === 1 || i === total_pages) {
					$this.show();
				} else {
					if (i < 4 && current_page < 4) {
						$this.show();
					} else if (i > (total_pages - 3) && current_page > (total_pages - 3)) {
						$this.show();
					} else if ((i >= current_page - 1) && (i <= current_page + 1)) {
						$this.show();
					} else {
						$this.hide();
					}
				}

			}

		});

		if (total_pages > 5) {
			if (current_page < 4) {
				show_back = true;
				show_front = false;
			} else if (current_page <= (total_pages - 3) && current_page >= 4) {
				show_back = true;
				show_front = true;
			} else if (current_page > (total_pages - 5)) {
				show_front = true;
				show_back = false;
			} else {
				show_front = false;
				show_back = false;
			}

			if (show_front) {
				$pagination.find('.ellipsis.front').show();
			} else {
				$pagination.find('.ellipsis.front').hide();
			}

			if (show_back) {
				$pagination.find('.ellipsis.back').show();
			} else {
				$pagination.find('.ellipsis.back').hide();
			}
		}

		if (current_page > 1) {
			$pagination.find('li.prev').show();
		} else {
			$pagination.find('li.prev').hide();
		}

		if (current_page < total_pages) {
			$pagination.find('li.next').show();
		} else {
			$pagination.find('li.next').hide();
		}
	}

	if ($paginated.length) {
	
		$paginated.each(function () {
			var $this = $(this),
				$pagination = $this.find('.pagination');

			paginated_update_pagination($this);

			$pagination.on('click', 'a', function (e) {
				var $this = $(this),
					$this_paginated = $this.closest('.paginated'),
					$loader = $this_paginated.find('.loader'),
					current_page = $this_paginated.data('current_page'),
					to_page,
					page_is_loaded,
					posts_per_page = $this_paginated.data('posts_per_page'),
					order = $this_paginated.data('order'),
					orderby = $this_paginated.data('orderby'),
					categories = $this_paginated.data('category_id'),
					show_featured_image = $this_paginated.data('show_featured_image'),
					blog_feed_module_type = $this_paginated.data('blog_feed_module_type'),
					et_column_type = $this_paginated.data('et_column_type'),
					show_author = $this_paginated.data('show_author'),
					show_categories = $this_paginated.data('show_categories'),
					show_date = $this_paginated.data('show_date'),
					show_rating = $this_paginated.data('show_rating'),
					show_more = $this_paginated.data('show_more'),
					show_comments = $this_paginated.data('show_comments'),
					date_format = $this_paginated.data('date_format'),
					content_length = $this_paginated.data('content_length'),
					hover_overlay_icon = $this_paginated.data('hover_overlay_icon'),
					use_tax_query = $this_paginated.data('use_tax_query'),
					tax_query = ('undefined' === typeof (EXTRA_TAX_QUERY) || 1 !== parseInt(use_tax_query)) ? [] : EXTRA_TAX_QUERY;

				e.preventDefault();
				
				if ($this.hasClass('ellipsis')) {
					return;
				} else if ($this.hasClass('arrow')) {
					if ($this.hasClass('prev')) {
						to_page = current_page - 1;
					} else {
						to_page = current_page + 1;
					}
				} else {
					to_page = $this.data('page');
				}
				
				page_is_loaded = $this_paginated.find('.paginated_page_' + to_page).length;

				if (page_is_loaded) {
					paginated_transition_page($this_paginated, to_page);
				} else {

					var $to_page_link = $this;
					if ($this.hasClass('arrow')) {
						$to_page_link = $this_paginated.find('.pagination-page-' + to_page);
					}

					$to_page_link_li = $to_page_link.parent();

					$loader.appendTo($to_page_link_li);
					$to_page_link.hide();

					if ($this_paginated.data('getting_more_content')) {
						return;
					}

					$this_paginated.data('getting_more_content', true);

					$.ajax({
						type: "POST",
						url: EXTRA.ajaxurl,
						data: {
							action: 'extra_blog_feed_get_content',
							et_load_builder_modules: '1',
							blog_feed_nonce: EXTRA.blog_feed_nonce,
							to_page: to_page,
							posts_per_page: posts_per_page,
							order: order,
							orderby: orderby,
							categories: categories,
							show_featured_image: show_featured_image,
							blog_feed_module_type: blog_feed_module_type,
							et_column_type: et_column_type,
							show_author: show_author,
							show_categories: show_categories,
							show_date: show_date,
							show_rating: show_rating,
							show_more: show_more,
							show_comments: show_comments,
							date_format: date_format,
							content_length: content_length,
							hover_overlay_icon: hover_overlay_icon,
							use_tax_query: use_tax_query,
							tax_query: tax_query
						},
						success: function (data) {

							if (data) {
								var $new_page = $(data);

								$new_page.appendTo($this_paginated.find('.paginated_content'));

								paginated_transition_page($this_paginated, to_page);

								setTimeout(function () {
									re_init_new_content($new_page);
								}, 500);
							}

							setTimeout(function () {
								$this_paginated.data('getting_more_content', false);
							}, 250);

							// reset loader image and re-show pagination page number
							$loader.appendTo($this_paginated);
							$to_page_link.show();
						}
					});
				}
			});
			
			// Added to run re_init_new_content on first page too in VB
			if ($module) {
				var $new_page = $this.find('.paginated_page.active:first');
				if ($new_page.length) {
					setTimeout(function () {
						re_init_new_content($new_page);
					}, 500);
				}
			}
			
			

		}); // end $paginated.each
	} // end if ( $paginated.length )

	if ($post_module.length) {
		$post_module.find('.title-thumb-hover').each(function () {
			var $this = $(this),
				$thumb = $this.find('.post-thumbnail > img'),
				$title = $this.find('.post-content > h3 > a'),
				title_hover_color = $title.data('hover-color');

			$title.hover(function () {
				$thumb.addClass('hover');
				$title.css({
					'color': title_hover_color
				});
			}, function () {
				$thumb.removeClass('hover');
				$title.css('color', '');
			});
		});
	}

	function tabbed_post_module_tab_change($tab) {
		var $module = $tab.parents('.tabbed-post-module'),
			tab_id = $tab.data('tab-id'),
			$tab_content = $module.find('.tab-content-' + tab_id),
			term_color = $tab.data('term-color');

		$tab.css({
			color: term_color
		});

		$module.css({
			borderTopColor: term_color
		});

		$tab_content.siblings().hide();

		$tab_content.stop().css({
			'display': 'flex'
		}).hide().fadeIn(300, 'swing');

		$tab.addClass('active').siblings().removeClass('active').css({
			color: ''
		});
	}

	if ($tabbed_post_module.length) {
		$tabbed_post_module.each(function () {

			// Set first active colors
			var $this = $(this),
				$tabs_container = $this.find('.tabs'),
				$tabs = $tabs_container.find('li'),
				tabs_count = $tabs.length,
				term_color = $tabs.first().data('term-color'),
				$arrow = $tabs_container.find('.arrow');

			$tabs.first().addClass('active').css({
				color: term_color
			});

			$this.css({
				borderTopColor: term_color
			});

			$tabs.hover(
				function () {
					$(this).css({
						color: $(this).data('term-color')
					});
				},
				function () {
					if (!$(this).hasClass('active')) {
						$(this).css({
							color: ''
						});
					}
				}
			);

			$tabs.click(function (e) {
				var $tab = $(this),
					$ripple_div = $('<div class="ripple" />'),
					ripple_size = 60,
					ripple_offset = $tab.offset(),
					ripple_y = e.pageY - ripple_offset.top,
					ripple_x = e.pageX - ripple_offset.left;

				if (!$(this).hasClass('active')) {
					tabbed_post_module_tab_change($tab);

					$ripple_div.css({
						top: ripple_y - (ripple_size / 2),
						left: ripple_x - (ripple_size / 2)
					}).appendTo($tab);
				}

				// Implement slider fix, in case the first post has gallery format
				et_slider_fix();

				window.setTimeout(function () {
					$ripple_div.remove();
				}, 900);
			});

			$arrow.on('click', function (e) {
				var $this = $(this),
					$active_tab = $tabs.filter('.active'),
					active_tab_index = $active_tab.index(),
					to_tab_index,
					$to_tab;

				if ($this.hasClass('prev')) {
					if ((active_tab_index) <= 0) {
						to_tab_index = tabs_count - 1;
					} else {
						to_tab_index = active_tab_index - 1;
					}
				} else {
					if ((active_tab_index + 1) >= tabs_count) {
						to_tab_index = 0;
					} else {
						to_tab_index = active_tab_index + 1;
					}
				}

				$to_tab = $tabs.eq(to_tab_index);

				tabbed_post_module_tab_change($to_tab);

				// Implement slider fix, in case the first post has gallery format
				et_slider_fix();
			});

		});
	} /* end if ( $tabbed_post_module.length ) */

	function et_featured_posts_slider_fix() {
		$featured_posts_slider_module.each(function () {
			var $featured_posts_slider = $(this),
				slider_width = $featured_posts_slider.width(),
				slider_height = (slider_width / 15.3) * 9;

			$featured_posts_slider.imagesLoaded(function () {
				$featured_posts_slider.each(function () {
					var $the_slider = $(this),
						$the_slide = $the_slider.find('.carousel-item'),
						$post_content_box = $the_slider.find('.post-content-box'),
						$nav_arrow = $the_slider.find('.et-pb-slider-arrows a'),
						is_relative_caption = $post_content_box.css('position') === 'relative' ? true : false,
						max_caption_height = 0,
						the_slider_height,
						nav_arrow_position_top;

					$the_slide.css({
						'height': ''
					});
					$nav_arrow.removeAttr('style');
					$post_content_box.removeAttr('style');

					if (is_relative_caption) {
						$the_slide.each(function () {
							var post_content_box_height = $(this).find('.post-content-box').height();
							if (post_content_box_height > max_caption_height) {
								max_caption_height = post_content_box_height;
							}
						});

						$post_content_box.css({
							'minHeight': max_caption_height,
							'marginTop': slider_height
						});

						the_slider_height = $the_slider.height();
						nav_arrow_position_top = ((the_slider_height - max_caption_height) / 2) - 20;
						$nav_arrow.css({
							'top': nav_arrow_position_top,
							'marginTop': 0
						});
					} else {
						$the_slide.height(slider_height);
					}
				});
			});
		});
	}

	if ($featured_posts_slider_module.length) {
		$featured_posts_slider_module.each(function () {
			var slideshow = $(this).data('autoplay');

			$(this).et_pb_simple_slider({
				slide: '.et_pb_slide', // slide class
				arrows: '.et-pb-slider-arrows', // arrows container class
				prev_arrow: '.et-pb-arrow-prev', // left arrow class
				next_arrow: '.et-pb-arrow-next', // right arrow class
				controls: '.et-pb-controllers a', // control selector
				carousel_controls: '.et_pb_carousel_item', // carousel control selector
				control_active_class: 'et-pb-active-control', // active control class name
				fade_speed: 500,
				use_arrows: true,
				use_controls: true,
				controls_class: 'et-pb-controllers',
				slideshow: typeof slideshow !== 'undefined',
				slideshow_speed: $.isNumeric(slideshow) ? slideshow * 1000 : 7000,
				show_progress_bar: false,
				tabs_animation: false,
				use_carousel: false
			});
		});

		et_featured_posts_slider_fix();

		window.addEventListener('resize', et_featured_posts_slider_fix);
	} /* end if ( $featured_posts_slider_module.length ) */

	function et_posts_carousel_init() {
		$posts_carousel_module.each(function () {
			var $the_carousel = $(this);
			var slideshow = $the_carousel.data('autoplay');
			var $carousel_items = $the_carousel.find('.carousel-items');
			var carousel_width = $carousel_items.width();
			var $carousel_group;
			var $carousel_item = $carousel_items.find('.carousel-item');
			var carousel_item_widths_array = $carousel_item.map(function() {
				return $(this).width();
			}).get();
			var carousel_item_width = Math.max.apply(null, carousel_item_widths_array);
			var carousel_item_thumb_widths_array = $carousel_item.find('.post-thumbnail').map(function() {
				return $(this).width();
			}).get();
			var carousel_item_thumb_width = Math.max.apply(null, carousel_item_thumb_widths_array);
			var carousel_item_thumb_height = (carousel_item_thumb_width / 15) * 9;
			var carousel_column = Math.round(carousel_width / carousel_item_width);
			var index = 0;
			var min_height = 0;
			var $current_carousel_group = $the_carousel.find('.carousel-group');
			var skip_group_height = false;
			var current_carousel_column;

			// Setup max-height for post thumbnail
			$carousel_item.find('.post-thumbnail').css({
				'maxHeight': carousel_item_thumb_height
			});

			// Remove existing column
			if ($current_carousel_group.length) {
				current_carousel_column = $carousel_items.find('.carousel-group:first .carousel-item').size();

				if (current_carousel_column === carousel_column) {
					fix_carousel_arrow_position();
					return;
				}

				$current_carousel_group.each(function () {
					$(this).find('.carousel-item').each(function () {
						$(this).appendTo($carousel_items);
					});
				}).remove();

				$the_carousel.find('.et-pb-slider-arrows').remove();
			}

			// If the column isn't valid, assume its the largest possible columns
			// Also, skip min height correction since it'll be invalid
			if (carousel_column > 4 || carousel_column < 1) {
				carousel_column = 4;
				skip_group_height = true;
			}

			// Group items
			$carousel_items.find('.carousel-item').each(function () {
				var $the_carousel_item = $(this);

				// Reset index
				if (carousel_column === index) {
					index = 0;
				}

				// Append new group
				if (index === 0) {
					$('<div />', {
						class: 'carousel-group et_pb_slide'
					}).appendTo($carousel_items);
				}

				// Append current item to last group
				$the_carousel_item.appendTo($carousel_items.find('.carousel-group:last'));

				index++;
			});

			$carousel_group = $the_carousel.find('.carousel-group');

			// Calculate group index
			if (skip_group_height === false) {
				$carousel_group.each(function () {
					var $the_carousel_group = $(this),
						carousel_group_height = $the_carousel_group.height();

					if (carousel_group_height > min_height) {
						min_height = carousel_group_height;
						$carousel_group.css({
							'min-height': min_height
						});
					}
				});
			}

			if ($carousel_items.data('et_pb_simple_slider')) {
				$carousel_items.data('et_pb_simple_slider').et_slider_destroy();
			}

			$carousel_items.et_pb_simple_slider({
				slide: '.et_pb_slide', // slide class
				arrows: '.et-pb-slider-arrows', // arrows container class
				prev_arrow: '.et-pb-arrow-prev', // left arrow class
				next_arrow: '.et-pb-arrow-next', // right arrow class
				controls: '.et-pb-controllers a', // control selector
				carousel_controls: '.et_pb_carousel_item', // carousel control selector
				control_active_class: 'et-pb-active-control', // active control class name
				fade_speed: 500,
				use_arrows: true,
				use_controls: false,
				slideshow: typeof slideshow !== 'undefined',
				slideshow_speed: $.isNumeric(slideshow) ? slideshow * 1000 : 7000,
				show_progress_bar: false,
				tabs_animation: false,
				use_carousel: false
			});

			// Remove loading state
			if ($the_carousel.hasClass('loading')) {
				$the_carousel.removeClass('loading');
				$carousel_item.removeClass('carousel-item-hide-on-load carousel-item-hide-on-load-medium carousel-item-hide-on-load-small');
			}

			// Never let carousel-group has empty slot
			$the_carousel.on('simple_slider_before_move_to', function (trigger, param) {
				var $carousel = $(this),
					$next_slide = $(param.next_slide),
					active_slide_item_count = $carousel.find('.et-pb-active-slide .carousel-item').size(),
					next_slide_item_count = $next_slide.find('.carousel-item').size(),
					remaining_item_count = active_slide_item_count - next_slide_item_count;

				if (remaining_item_count > 0) {
					var is_next = param.direction === 'next',
						carousel_item_count = $the_carousel.find('.carousel-group').size(),
						next_slide_index = $next_slide.index() + 1,
						correction_slide_index,
						$correction_slide,
						$correction_slide_item;

					if (is_next) {
						if ((next_slide_index + 1) > carousel_item_count) {
							correction_slide_index = 1;
						} else {
							correction_slide_index = next_slide_index + 1;
						}
					} else {
						if ((next_slide_index - 1) < 1) {
							correction_slide_index = carousel_item_count;
						} else {
							correction_slide_index = next_slide_index - 1;
						}
					}

					$correction_slide = $carousel.find('.carousel-group:nth-child(' + correction_slide_index + ')');

					$the_carousel.addClass('et-pb-slide-is-transitioning');

					if (is_next) {
						$correction_slide_item = $correction_slide.find('.carousel-item:lt(' + (remaining_item_count) + ')');

						$next_slide.append($correction_slide_item.clone());
					} else {
						$correction_slide_item = $correction_slide.find('.carousel-item:gt(' + (active_slide_item_count - remaining_item_count - 1) + ')');

						$next_slide.prepend($correction_slide_item.clone());
					}

					$the_carousel.one('simple_slider_after_move_to', function () {
						$correction_slide_item.remove();
						$the_carousel.removeClass('et-pb-slide-is-transitioning');
					});
				}
			});

			function fix_carousel_arrow_position() {
				// Fix arrow position
				var $updated_carousel_group = $the_carousel.find('.carousel-group'),
					$updated_carousel_group_thumb = $updated_carousel_group.find('.post-thumbnail'),
					updated_carousel_group_thumb_height = $updated_carousel_group_thumb.height(),
					carousel_arrow_constant = parseInt($updated_carousel_group_thumb.css('marginLeft')) === 0 ? 5 : 25,
					carousel_arrow_top = (updated_carousel_group_thumb_height / 2) + carousel_arrow_constant;

				$the_carousel.find('.et-pb-slider-arrows a').css({
					'top': carousel_arrow_top
				});
			}

			$the_carousel.imagesLoaded(function () {
				fix_carousel_arrow_position();
			});
		});
	}

	if ($posts_carousel_module.length) {
		et_posts_carousel_init();

		window.addEventListener('resize', et_posts_carousel_init);
	} /* end if ( $posts_carousel_module.length ) */
	
	function re_init_new_content($new_content) {
		//init_videos(); temp comment out

		if ($new_content.find('.et-slider').length) {
			$new_sliders = $new_content.find('.et-slider');
			$new_sliders.each(function () {
				et_slider_setup($(this));
			});
			et_slider_fix();
		}

		if ($new_content.find('.wp-audio-shortcode, .wp-video-shortcode').length) {
			var settings = {};

			if (typeof _wpmejsSettings !== 'undefined') {
				settings.pluginPath = _wpmejsSettings.pluginPath;
			}

			settings.success = function (mejs) {
				var autoplay = mejs.attributes.autoplay && 'false' !== mejs.attributes.autoplay;
				if ('flash' === mejs.pluginType && autoplay) {
					mejs.addEventListener('canplay', function () {
						mejs.play();
					}, false);
				}
			};
			$new_content.find('.wp-audio-shortcode, .wp-video-shortcode').mediaelementplayer(settings);
		}

		if ($new_content.find('.post-format-map').length) {
			$new_maps = $new_content.find('.post-format-map');
			$new_maps.each(function () {
				et_simple_marker_map($(this));
			});
		}

		// Re-apply Salvattore grid to the new content.
		if ('undefined' !== $new_content.attr('data-columns')) {
		console.log('creating grid');
			salvattore.registerGrid($new_content[0]);
			salvattore.recreateColumns($new_content[0]);
		}

	}
	
	function et_calclate_admin_bar_height() {
		var admin_bar = $('#wpadminbar').length,
			admin_bar_height = 0,
			admin_bar_position;

		if (admin_bar) {
			admin_bar_position = $('#wpadminbar').length ? $('#wpadminbar').css('position') : '';
			admin_bar_height = $('#wpadminbar').length ? $('#wpadminbar').height() : 0;
			if ('fixed' !== admin_bar_position) {
				admin_bar_height = 0;
			}
		}

		return admin_bar_height;
	}
	
	function et_slider_fix() {
		$et_slider.each(function () {
			var $slider = $(this);

			$slider.each(function () {
				var $the_slider = $(this),
					$the_slide = $the_slider.find('.carousel-item'),
					slide_max_height = 0;

				// Remove transition class to prevent unwanted transition when element reappearing
				$the_slider.removeClass('et_slide_transition_to_previous et_slide_transition_to_next');

				$the_slider.imagesLoaded(function () {
					$the_slider.removeAttr('style');

					$the_slide.each(function () {
						var slide_height = $(this).height();

						if (slide_max_height === 0 || slide_max_height > slide_height) {
							slide_max_height = slide_height;
						}
					});

					$the_slider.css({
						'maxHeight': slide_max_height
					});
				});
			});
		});
	}

}

jQuery(document).ready(function() {
	agsdcm_extra();
}); /* end $(document).ready */







// Code after this line is original by Aspen Grove Studios

// Following code is copied from WP and Divi Icons Pro by Aspen Grove Studios, modified
jQuery(document).ready(function($) {
	var fbBody = $('body.et-fb');
	if (fbBody.length) {
		var MO = window.MutationObserver ? window.MutationObserver : window.WebkitMutationObserver;
		if (MO) {
			(new MO(function(events) {
				$.each(events, function(i, event) {
					if (event.target) {
						var $element = $(event.type === 'characterData' ? event.target.parentElement : event.target);
						if (event.addedNodes && event.addedNodes.length) {
							$(event.addedNodes).find('.ags-divi-extras-module').addBack('.ags-divi-extras-module').each(function() {
								agsdcm_extra($(this));
							});
						}
					}
				});
			})).observe(fbBody[0], {childList: true, subtree: true});
		}
	}
});
// End code copied from WP and Divi Icons Pro